package com.roco.settle.api.enums.enterprisetransfer;

import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EnterpriseTransferOperate {

    /**
     * 提交
     */
    SUBMIT(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.NULL,
            EnterpriseTransferStatus.DRAFT},
            EnterpriseTransferStatus.CONFIRMING),

    /**
     * 删除
     */
    DELETE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.DRAFT},
            EnterpriseTransferStatus.DELETED),


    /**
     * 确认
     */
    CONFIRM(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMING},
            EnterpriseTransferStatus.CONFIRMED),

    /**
     * 关联主体结算
     */
    RELATE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMED},
            EnterpriseTransferStatus.RELATED),

    /**
     * 处理完成
     */
    COMPLETE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED},
            EnterpriseTransferStatus.COMPLETE),


    /**
     * 关联基点结算
     */
    RELATE_BASE_POINT(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.COMPLETE},
            EnterpriseTransferStatus.RELATED_BASE_POINT),


    /**
     *  关联基点结算回滚
     */
    RELATE_BASE_POINT_ROLLBACK(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED_BASE_POINT},
            EnterpriseTransferStatus.COMPLETE),


    /**
     * 已结算
     */
    SETTLE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED_BASE_POINT},
            EnterpriseTransferStatus.SETTLED),

    /**
     * 取消
     */
    CANCEL(new EnterpriseTransferStatus[]{
            EnterpriseTransferStatus.CONFIRMING,
            EnterpriseTransferStatus.CONFIRMED,
    }, EnterpriseTransferStatus.CANCEL),

    /**
     * 关联回滚
     */
    RELATED_ROLLBACK(new EnterpriseTransferStatus[]{
            EnterpriseTransferStatus.RELATED},
            EnterpriseTransferStatus.CONFIRMED);


    @Getter
    private EnterpriseTransferStatus[] before;
    @Getter
    private EnterpriseTransferStatus after;


    public  List<String> getBeforeList() {
        return Stream.of(before).map(EnterpriseTransferStatus::name).collect(Collectors.toList());
    }

    EnterpriseTransferOperate(EnterpriseTransferStatus[] before, EnterpriseTransferStatus after) {
        this.before = before;
        this.after = after;
    }
}
