package com.roco.settle.api.request.enterprisetansfer.settle;

import com.roco.settle.api.enums.enterprisetransfer.EnterpriseTransferHandleType;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 状态更新
 * @author Andrew
 * @create 2020/2/27 4:47 下午
 */
@Data
public class EnterpriseTransferHandleStatusUpdateReq implements Serializable {


    @NotNull
    private EnterpriseTransferHandleType handleType;

    /**
     * 结算的单号
     */
    @NotBlank
    private String applyNo;

    /**
     * 对应的工单号    发票工单 or 支付工单
     */
    @NotBlank
    private String orderNo;

    /**
     * 最新的状态
     */
    @NotBlank
    private String status;
}
