package com.roco.settle.api.entity.agent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author djt
 * @Description: 代理人标准套餐明细
 * @date 2020/10/30 11:36
 */
@Data
public class SettleStandardPackageItem implements Serializable {
    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 标准套餐编码（settle_standard_package.code）
     */
    private String packageCode;

    /**
     * 机构产品编码（settle_enterprise_product_rel.code）
     */
    private String productCode;

    /**
     * 机构产品简称
     */
    private String productSimpleName;

    /**
     * 产品市场价
     */
    private BigDecimal faceValue;

    /**
     * 产品成本
     */
    private BigDecimal cost;

    /**
     * 产品采购价
     */
    private BigDecimal purchasingPrice;

    /**
     * 产品数量
     */
    private Integer productCount;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     *
     */
    private String createName;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     *
     */
    private String updateName;
}
