package com.roco.settle.api.request.expense.enterprise;

import com.roco.settle.api.enums.ExpanseItemOnlineStatus;
import lombok.Data;

import java.io.Serializable;


/**
 * 费用项目管理(SettleExpenseItem)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:50:46
 */
@Data
public class SettleExpenseItemEnterprisePageOneReq implements Serializable {
    /**
     * 机构编码(业务基点)
     */
    private String enterpriseCode;
    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 费用项目编码
     */
    private String itemCode;
    /**
     * 项目简称
     */
    private String simpleName;
    /**
     * 产品分类*/
    private String catalogCode;
    /**
     * 项目性质
     * */
    private String projectNature;

    /**
     * 项目状态
     * */
    private Integer status;
    /**
     * 上下架状态
     * */
    private ExpanseItemOnlineStatus isOnline;
}