package com.roco.settle.api.request.policy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author luoyingchang
 * @date 2020-07-14
 */
@Getter
@Setter
public class PolicyGiftDirectDetailReq implements Serializable {


    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 明细编号(唯一)
     */
    private String detailNo;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseName;

    /**
     * 推修码
     */
    private String repairNo;

    /**
     * 渠道商编码(推修码)
     */
    private String channelCode;

    /**
     * 渠道商名称
     */
    private String channelName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 模式: 额度:quota、比例:ratio
     */
    private String giftMode;

    /**
     * 口径(保费模式) 保费:premium、净保费:net_premium
     */
    private String policyType;

    /**
     * 比例 例如: 100% =  1.0000、52.3% = 0.5230 3.21% = 0.0321
     */
    private BigDecimal ratio;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 保费
     */
    private BigDecimal premium;

    /**
     * 净保费
     */
    private BigDecimal netPremium;

    /**
     * 车牌号
     */
    private String carLicense;

    /**
     * 车主姓名
     */
    private String carOwer;

    /**
     * 出单人
     */
    private String drawer;

    /**
     * 出单人手机号
     */
    private String darwerMobile;

    /**
     * 申请备注
     */
    private String remark;

    /**
     * 状态: 草稿:draft、作废:invalid、待处理:pending、待结算:settling、完成:finish
     */
    private String status;

    /**
     * 申请人id
     */
    private Integer createUser;

    /**
     * 申请人姓名
     */
    private String createName;

    /**
     * 申请人类型 customer, system
     */
    private String createUsertype;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 申请日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 提交时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime submitTime;

    /**
     * 提交日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate submitDate;

    /**
     * 处理时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime handleTime;

    /**
     * 处理日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate handleDate;

    /**
     * 结算时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime settleTime;

    /**
     * 结算日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate settleDate;

    /**
     * 作废时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime invalidTime;

    /**
     * 作废日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate invalidDate;

    /**
     * 业务状态 待处理:pending、已处理:processed、已作废:invalid
     */
    private String bizStatus;

    /**
     * 结算状态 未结算:unsettled、已结算:settled
     */
    private String settleStatus;

    private String enterpriseCodes;

}
