package com.roco.settle.api.request.supplier.product;


import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 保存平台商品与备付金账户的关联关系
 * @author djt
 */
@Data
public class ProductReferenceSupplierDepositReq implements Serializable {

    /**
     * 平台商品编号
     */
    @NotBlank(message = "平台商品编号不能为空")
    private String productCode;

    /**
     * 备付金账户
     */
    @NotBlank(message = "备付金账户不能为空")
    private String acctCode;
}
