package com.roco.settle.api.service;

import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseTransferHandleApply;
import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseTransferHandleLog;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.enterprisetansfer.settle.EnterpriseTransferHandleApplyReq;
import com.roco.settle.api.request.enterprisetansfer.settle.EnterpriseTransferHandleOperateReq;
import com.roco.settle.api.request.enterprisetansfer.settle.EnterpriseTransferHandleQueryReq;
import com.roco.settle.api.request.enterprisetansfer.settle.EnterpriseTransferHandleStatusUpdateReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * 对公转账 结算
 * @author Andrew
 * @create 2020/2/26 5:29 下午
 */
public interface EnterpriseTransferSettleService {


    /**
     * 结算申请
     * @param request
     * @return
     */
    CommonResponse<String> apply(CommonRequest<EnterpriseTransferHandleApplyReq> request);


    /**
     * 分页查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseTransferHandleApply> page(CommonQueryPageRequest<EnterpriseTransferHandleQueryReq> request);


    /**
     * 删除， 确认 ，取消
     * @param request
     * @return
     */
    CommonResponse<Boolean> operate(CommonRequest<EnterpriseTransferHandleOperateReq> request);


    /**
     * 状态更新
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<EnterpriseTransferHandleStatusUpdateReq> request);


    /**
     * 详情
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseTransferHandleApply> detail(CommonRequest<EnterpriseTransferHandleQueryReq> request);


    /**
     * 日志查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseTransferHandleLog> log(CommonQueryPageRequest<EnterpriseTransferHandleQueryReq> request);
}
