package com.roco.settle.api.enums.billing;

public enum SettleSubjectBillingOperationEnum {
    /**
     * 创建
     */
    CREATE_SYSTEM("系统创建"),
    /**
     * 添加发票
     */
    ADD_INVOICE("添加发票"),
    /**
     * 确认已开票
     * */
    INVOICE_CONFIRMATION("确认已开票"),
    /**
     * 添加寄送信息
     * */
    ADD_SEND("添加寄送信息"),
    /**
     * 确认已寄送
     * */
   SEND_CONFIRMATION("确认已寄送"),
    /**
     * 提交
     * */
    SING_CONFIRMATION("确认客户已收票"),
    /**
     * 取消
     * */
    CANCEL("取消");

    private String name;

    SettleSubjectBillingOperationEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        SettleSubjectBillingOperationEnum[] values = SettleSubjectBillingOperationEnum.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
