package com.roco.settle.api.enums.invoice;

import lombok.Getter;

/**
 * 发票申请状态枚举类
 * @author dongjuntong
 */
public enum InvoiceApplyStatusEnum {
    /***
     *空
     */
    EMPTY("5","空"),
    /**
     * 草稿
     */
    DRAFT("0","草稿"),

    /**
     * 待确认
     */
    UNCONFIRMED("1","待确认"),

    /**
     * 已入库
     */
    CONFIRMED("2","已入库");



    @Getter
    private String label;

    @Getter
    private String code;

    InvoiceApplyStatusEnum(String code, String label){
        this.code=code;
        this.label=label;
    }
}
