package com.roco.user.api.entity;

import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author djt
 * @Description: 机构额度配置
 * @date 2020/11/6 16:37
 */
@Data
@Table(name="oil_account_conf")
public class OilAccountConf implements Serializable {

    private String orgName;

    private String orgNo;

    /**
     * 变更后关联的操作
     *
     */
    private String updateRefOperate;

    /**
     * 投保礼账户开关 1开  0关
     */
    private Integer  accountSwitch;

    /**
     * 投保礼现金开关 1开  0关
     */
    private Integer  cashSwitch;


    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     *  创建人姓名
     */
    private String createName;


    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     *  更新人姓名
     */
    private String updateName;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
