package com.roco.settle.api.enums;


import com.roco.settle.api.entity.supplier.ProductSettlement;

import java.math.BigDecimal;

public enum ProductSettlementModeEnum {
    DIFF_SALES(0, "进销差"),
    PROMOTION_SERVICE_FEE(1, "收推广服务费"),
    ;
    private int code;
    private String msg;

    public static ProductSettlementModeEnum getByCode(int code) {
        for (ProductSettlementModeEnum v : values()) {
            if (v.code == code) {
                return v;
            }
        }
        return null;
    }

    ProductSettlementModeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }


    private void checkMode(ProductSettlementModeEnum target) {
        if (this != target) {
            throw new IllegalArgumentException("该结算模式没有此方法，该方法存在[" + target.msg + "]模式下");
        }
    }
    /**
     * 采购价
     */
    public BigDecimal getPurchasePrice(ProductSettlement productSettlement) {
        checkMode(DIFF_SALES);
        return productSettlement.getPurchasePrice();
    }

    /**
     * 中介代理服务费(Intermediary agency service fee
     */
    public BigDecimal getIyasFee(ProductSettlement productSettlement) {
        checkMode(DIFF_SALES);
        return productSettlement.getIyasFee();
    }

    /**
     * 保险代理服务费(Insurance agency service fee)
     */
    public BigDecimal getIeasFee(ProductSettlement productSettlement) {
        checkMode(DIFF_SALES);
        return productSettlement.getIeasFee();
    }

    /**
     * 销售价
     */
    public BigDecimal getSellPrice(ProductSettlement productSettlement) {
        checkMode(DIFF_SALES);
        return productSettlement.getSellPrice();
    }

    /**
     * 推广服务费系数(Promotion service fee ratio)
     */
    public BigDecimal getPsfRatio(ProductSettlement productSettlement) {
        checkMode(PROMOTION_SERVICE_FEE);
        return productSettlement.getPsfRatio();
    }
}
