package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.SupplierServiceApplyItem;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.supplier.serviceapplyitem.SupplierServiceApplyItemPageReq;
import com.roco.settle.api.request.supplier.serviceapplyitem.SupplierServiceApplyItemReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;
import java.util.Map;

public interface SupplierServiceApplyItemService {

    /**
     * 批量保存清单明细
     * @param request
     * @return
     */
    CommonResponse<Boolean> batchSave(CommonRequest<SupplierServiceApplyItemReq> request);

    /**
     * 更新服务清单名细状态
     * @param request
     * @return
     */
    CommonResponse<Map<Integer,String>> updateStatus(CommonRequest<SupplierServiceApplyItemReq> request);

//    /**
//     * 统计传入清单的总笔数和总金额
//     * @param request
//     * @return
//     */
//    CommonResponse<SupplierServiceApplyItemCollectResp> collectServiceItem(CommonRequest<SupplierServiceApplyItemReq> request);
//
//    /**
//     * 占用服务清单
//     * @param request
//     * @return
//     */
//    CommonResponse<SupplierServiceApplyItemCollectResp> allocateServiceItem(CommonRequest<SupplierServiceApplyItemReq> request);

//    /**
//     * 使用服务清单
//     * @param request
//     * @return
//     */
//    CommonResponse<Boolean> usedServiceItem(CommonRequest<SupplierServiceApplyItemReq> request);
//
//    /**
//     * 取消使用服务清单
//     * @param request
//     * @return
//     */
//    CommonResponse<Boolean> cancelServiceItem(CommonRequest<SupplierServiceApplyItemReq> request);


    /**
     * 分页查询服务清单明细
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SupplierServiceApplyItem> page(CommonQueryPageRequest<SupplierServiceApplyItemPageReq> pageRequest);

    /**
     * 不分页查询服务清单明细
     * @param request
     * @return
     */
    CommonResponse<List<SupplierServiceApplyItem>> list(CommonRequest<SupplierServiceApplyItemPageReq> request);

}
