package com.roco.settle.api.entity.enterprisetansfer;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 结算业务基点对公费用(SettleEnterpriseBasePointApply)实体类
 *
 * @author Andrew
 * @since 2020-02-29 18:50:46
 */
@Data
@Table(name = "settle_enterprise_base_point_apply")
public class SettleEnterpriseBasePointApply implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 事项名称  
     */
    private String itemName;

    /**
     * 事项说明  
     */
    private String itemDesc;

    /**
     * 业务基点简称  
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码  
     */
    private String enterpriseCode;

    /**
     * 是否人保机构  
     */
    private Long isPicc;

    /**
     * 人保机构编码  
     */
    private String piccOrgCode;

    /**
     * 对公转账申请单  
     */
    private String enterpriseTransferApplyNo;

    /**
     * 结算价格  
     */
    private BigDecimal totalPackageAmount;

    /**
     * 状态  
     */
    private String status;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    private String updateUser;

    private String updateName;

   

}