package com.roco.settle.api.entity.enterprise;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/11/9 17:54</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class EnterpriseCustom implements Serializable {
    /**
     * 主键
     */
    private Integer id;

    /**
     *  企业名称
     */
    private String name;

    /**
     *  名称首字母
     */
    private String nameFirstPinyin;

    /**
     *  简称
     */
    private String simpleName;

    /**
     *  
     */
    private String code;

    /**
     * 状态：0；停用、1；启用
     */
    private Integer status;

    /**
     * 是否合作；0否、1是
     */
    private Integer isCooperation;

    private Boolean spread;

    /**
     *  行业编码
     */
    private String industryCode;

    /**
     * 行业id
     */
    private Integer industryId;

    /**
     *  企业类型编码
     */
    private String enterpriseTypeCode;

    /**
     * 业务性质(SUMMARY: 汇总机构, BASE_POINT: 业务基点)
     */
    private String bizNature;

    /**
     * 排序号
     */
    private Integer seq;

    /**
     * 企业层级
     */
    private Integer level;

    /**
     * 上级id
     */
    private Integer pid;

    /**
     * 是否人保；0否、1是
     */
    private Integer isPicc;

    /**
     *  人保机构名
     */
    private String piccOrgName;

    /**
     *  人保机构码
     */
    private String piccOrgCode;

    /**
     *  上级人保机构名
     */
    private String parPiccOrgName;

    /**
     *  上级人保机构码
     */
    private String parPiccOrgCode;

    /**
     *  所在地
     */
    private String localtion;

    /**
     *  所在省
     */
    private String province;

    /**
     *  所在市
     */
    private String city;

    /**
     *  所在区
     */
    private String area;

    /**
     *  省名称
     */
    private String provinceName;

    /**
     *  城市名称
     */
    private String cityName;

    /**
     *  区名称
     */
    private String areaName;

    /**
     *  详细地址
     */
    private String address;

    /**
     * 销售主体编码(settle_biz_subject.code)
     */
    private String subjectCode;

    /**
     * 销售主体简称(settle_biz_subject.simple_name)
     */
    private String subjectSimpleName;

    /**
     * 创建日期
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 层级1编码
     */
    private String levelCode1;

    /**
     * 层级2编码
     */
    private String levelCode2;

    /**
     * 层级3编码
     */
    private String levelCode3;

    /**
     * 层级4编码
     */
    private String levelCode4;

    /**
     * 层级5编码
     */
    private String levelCode5;

    /**
     * 层级6编码
     */
    private String levelCode6;

    /**
     * 层级7编码
     */
    private String levelCode7;

    /**
     * 额度追加次数
     */
    private Integer limitAddCnt;

    /**
     * 平均额度追加周期
     */
    private Integer limitAddPeriod;

    /**
     * 首次授额时间
     */
    private LocalDateTime firstAddTime;

    /**
     * 首次发券时间
     */
    private LocalDateTime firstUseTime;

    /**
     * 最后授额时间
     */
    private LocalDateTime lastAddTime;

    /**
     * 最后授额日期
     */
    private LocalDate lastAddDate;

    /**
     * 首次发券日期
     */
    private LocalDate firstUseDate;

    /**
     * 首次授额日期
     */
    private LocalDate firstAddDate;
}