package com.roco.settle.api.enums.enterprisetransfer;

import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EnterpriseBasePointOperate {

    /**
     * 提交
     */
    SUBMIT(new EnterpriseBasePointStatus[]{EnterpriseBasePointStatus.NULL,
            EnterpriseBasePointStatus.DRAFT},
            EnterpriseBasePointStatus.PENDING),

    /**
     * 删除
     */
    DELETE(new EnterpriseBasePointStatus[]{EnterpriseBasePointStatus.DRAFT},
            EnterpriseBasePointStatus.DELETED),


    /**
     * 处理
     */
    COMPLETE(new EnterpriseBasePointStatus[]{EnterpriseBasePointStatus.PENDING},
            EnterpriseBasePointStatus.COMPLETE),

    /**
     * 取消
     */
    CANCEL(new EnterpriseBasePointStatus[]{
            EnterpriseBasePointStatus.PENDING,
    }, EnterpriseBasePointStatus.CANCEL);


    @Getter
    private EnterpriseBasePointStatus[] before;
    @Getter
    private EnterpriseBasePointStatus after;


    public List<String> getBeforeList() {
        return Stream.of(before).map(EnterpriseBasePointStatus::name).collect(Collectors.toList());
    }

    EnterpriseBasePointOperate(EnterpriseBasePointStatus[] before, EnterpriseBasePointStatus after) {
        this.before = before;
        this.after = after;
    }
}
