package com.roco.settle.api.request.expense.item;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 费用项目管理(SettleExpenseItem)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:50:46
 */
@Data
public class SettleExpenseItemSaveReq implements Serializable {


    /**
     * 类目编码
     */
    @NotBlank(message = "类目不可为空")
    private String catalogCode;

    /**
     * 名称  
     */
    @NotBlank(message = "名称不可为空")
    private String name;

    /**
     * 名称拼音  
     */
    private String namePy;

    /**
     * 简称  
     */
    @NotBlank(message = "简称不可为空")
    private String simpleName;

    /**
     * 简称拼音  
     */
    private String simpleNamePy;

    /**
     * 项目说明
     */
    private String introduction;

    /**
     * 状态(0停用1启用)  
     */
    @NotNull(message = "状态不可为空")
    private Integer status;

    /**
     * 项目性质
     * */
    @NotBlank(message = "项目性质不可为空")
    private String projectNature;
   

}