package com.roco.settle.api.request.settlecapital;

import com.roco.settle.api.enums.SettleCapitalType;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/3/4 5:26 下午
 */
@Data
public class SettleCapitalAccountSettleReq implements Serializable {


    @NotBlank
    private String bizSubjectCode;

    @NotBlank
    private String enterpriseCode;

    @NotNull
    private SettleCapitalType type;


    @NotNull
    @DecimalMin("0.001")
    private BigDecimal settleAmount;

    @NotBlank
    private String applyNo;

    private String applyItemName;

    /**
     * 结算点数
     */
    private String settlePoint;


}
