package com.roco.settle.api.service.agent;

import com.roco.settle.api.entity.agent.SettleStandardPackage;
import com.roco.settle.api.entity.agent.SettleStandardPackageLog;
import com.roco.settle.api.request.agent.StandardPackageProductSearchReq;
import com.roco.settle.api.request.agent.StandardPackageSaveReq;
import com.roco.settle.api.request.agent.StandardPackageSearchReq;
import com.roco.settle.api.request.agent.StandardPackageUpdateStatusReq;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.response.agent.SettleStandardPackageExtResp;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

/**
 * @author djt
 * @Description: 标准套餐接口
 * @date 2020/10/30 11:39
 */
public interface SettleStandardPackageService {

    /**
     * 创建机构标准套餐
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<StandardPackageSaveReq> request);

    /**
     * 修改机构标准套餐
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<StandardPackageSaveReq> request);

    /**
     * 分页查询套餐
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleStandardPackage> page(CommonQueryPageRequest<StandardPackageSearchReq> request);

    /**
     * 不分页查询套餐
     * @param request
     * @return
     */
    CommonResponse<List<SettleStandardPackage>> list(CommonRequest<StandardPackageSearchReq> request);


    /**
     * 根据套餐编码查询套餐详情
     * @param request
     * @return
     */
    CommonResponse<SettleStandardPackageExtResp> detail(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 更新套餐状态
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<StandardPackageUpdateStatusReq> request);


    /**
     * 根据套餐编号查询套餐操作日志
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleStandardPackageLog> logPage(CommonQueryPageRequest<StandardPackageSearchReq> request);

    /**
     * 选择套餐列表
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleStandardPackageExtResp> packageProductList(CommonQueryPageRequest<StandardPackageProductSearchReq> request);
}
