package com.roco.settle.api.entity.supplier;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author lq
 * @create 2020/2/19 11:02 上午
 */
@Data
@Table(name = "sc_supplier")
public class Supplier implements Serializable {
	/**
	 * 供应商ID
	 */
    @Id
	private Long supplierId;
	/**
	 * 供应商编号
	 */
	private String supplierNo;
	/**
	 * 供应商名称
	 */
	private String supplierName;
	/**
	 * 简介
	 */
	private String description;
	/**
	 * 地区编号
	 */
	private String regionNo;
	/**
	 * 省
	 */
	private String province;
	/**
	 * 市
	 */
	private String city;
	/**
	 * 区
	 */
	private String area;

    /**
     * 省
     */
    private String provinceCode;
    /**
     * 市
     */
    private String cityCode;
    /**
     * 区
     */
    private String areaCode;
	/**
	 * 详细地址
	 */
	private String address;
	/**
	 * 法人
	 */
	private String legalPerson;
	/**
	 * 营业执照编号
	 */
	private String businessLicenseNo;
	/**
	 * 营业执照图片(阿里云)
	 */
	private String businessLicenseImg;
	/**
	 * 状态
	 */
	private Integer status;

	/**
	 * 搜索名
	 */
	private String searchName;

	/**
	 * 供应商类型
	 * */
	private String providerType;

	/**
	 * 服务类型
	 * */
	private String categoryCode;

	/**
	 * 服务类型
	 * */
	private String categoryName;
	/**
	 * *
	 * * 是否主体*/
	private String mainPartType;

	/**
	 * 主体编码
	 * */
	private String mainPartCode;


	/**
	 * 营业执照名称
	 * */
	private String licenseName;
    /**
     * 营业执照名称
     * */
    private String licenseNamePy;

	/**
	 * *
	 * * 人保车务平台门店编号*/
	private String shopCode ;

	/**
	 * 是否人保车务平台上架
	 * */
	private String isOnline;
    /**
     * 商户类型
     * */
    private String merchantTypeCode;
    /**
     * 商户类型名称
     * */
    private String merchantTypeName;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    @Column(name="create_name")
    private String createUsername;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    @Column(name="update_name")
    private String updateUsername;
    /**
     * 更新人类型
     * */

    private String updateUsertype;

    /**
     * 更新日期
     * */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

	/**
	 * 人保推修码
	 */
	private String insuranceRepairNo;
}
