package com.roco.settle.api.request.expense.supplier;

import com.roco.settle.api.entity.expense.SettleExpenseItemSupplier;
import lombok.Data;

import javax.persistence.Id;
import javax.validation.constraints.*;
import java.math.BigDecimal;


/**
 * 供应商结算信息(SettleExpenseItemSupplier)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:52:41
 */
@Data
public class SettleExpenseItemSupplierSaveReq extends SettleExpenseItemSupplier {

    private Long id;

    /**
     * 供应商基点结算信息编码
     */
    private String code;

    /**
     * 费用项目编码
     */
    @NotBlank(message = "项目编码不可为空")
    private String itemCode;

    /**
     *  供应商编号
     */
    @NotBlank(message = "供应商不可为空")
    private String supplierCode;

    /**
     *  供应商名称
     */
    @NotBlank(message = "供应商不可为空")
    private String supplierName;

    /**
     * 营业执照名称
     */
    private String licenseName;

    /**
     * 人保车务平台门店编号
     */
    private String shopCode;

    /**
     * 供应商结算价格
     */
    @DecimalMin(value = "0.01",message = "打款金额不可为空")
    @Digits(integer = 10, fraction = 2, message = "最多两位小数")
    private BigDecimal settlementPrice;

    /**
     * 结算价格说明
     */
    private String priceRemark;

    /**
     * 发票类型   增值税专用发票：DEDICATED ，增值税普通发票：NORMAL
     */
    @Pattern(regexp = ("^(DEDICATED|NORMAL)$"),message = "发票类型参数不匹配")
    private String invoiceType;

    /**
     * 税额
     */
    /**
     * 税率
     */
    @NotNull(message = "发票税率不能为空")
    private BigDecimal invoiceTaxRate;
}