package com.roco.settle.api.entity.order;

import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 供应商开票订单操作记录(SupplierInvoiceOrderOperateLog)实体类
 *
 * @author dongjuntong
 * @since 2020-02-24 10:57:29
 */
@Data
@Table(name = "supplier_invoice_order_operate_log")
public class SupplierInvoiceOrderOperateLog implements Serializable {

   
    @Id
    private Long id;

    /**
     * 供应商开票订单编码  
     */
    private String orderCode;

    /**
     * 操作  
     */
    private String operation;

    /**
     * 操作人id  
     */
    private Long createUser;

    /**
     * 操作人名称  
     */
    private String createName;

    /**
     * 操作时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name = "create_time")
    private LocalDateTime createTime;

    /**
     * 操作备注  
     */
    private String remark;

   

}