package com.roco.settle.api.entity.expense;

import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 费用项目管理(SettleExpenseItem)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:50:46
 */
@Data
@Table(name = "settle_expense_item")
public class SettleExpenseItem implements Serializable {

   
    @Id
    private Long id;

    /**
     * 费用项目管理code  
     */
    private String code;
    /**
     * 类目编码
     */
    private String catalogCode;
    /**
     * 类目名称 冗余字段
     */
    @Transient
    private String catalogName;

    /**
     * 名称  
     */
    private String name;

    /**
     * 名称拼音  
     */
    private String namePy;

    /**
     * 简称  
     */
    private String simpleName;

    /**
     * 简称拼音  
     */
    private String simpleNamePy;

    /**
     * 工单说明  
     */
    private String introduction;

    /**
     * 状态(0停用1启用)  
     */
    private Integer status;

    /**
     * 创建时间  
     */
     @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 创建人类型  
     */
    private String createUsertype;

    /**
     * 更新时间  
     */
     @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人姓名  
     */
    private String updateName;

    /**
     *  更新人类型  
     */
    private String updateUsertype;

    /**
     * 逻辑删除（0：未删除，1：已删除）  
     */
    private Integer deleted;

    /**
     * 项目性质
     * */
    private String projectNature;

   

}