package com.roco.settle.api.request.expense.enterprise;

import com.roco.settle.api.entity.expense.SettleExpenseItemEnterprise;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 费用项目管理(SettleExpenseItem)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:50:46
 */
@Data
public class SettleExpenseItemEnterpriseUpdateReq implements Serializable {

    @NotNull(message = "主键不可为空")
    private Long id;
//
//    /**
//     * 业务基点结算信息编码
//     */
//    private String code;
//
//    /**
//     * 费用项目编码
//     */
//    private String itemCode;
//
//    /**
//     * 机构编码(业务基点)
//     */
//    private String enterpriseCode;
//
//    /**
//     * 机构名称
//     */
//    private String enterpriseName;
//
//    /**
//     * 机构简称（业务基点）
//     */
//    private String enterpriseSimpleName;
//
//    /**
//     * 是否人保；0否、1是
//     */
//    private Long isPicc;
//
//    /**
//     * 人保机构号
//     */
//    private String piccOrgCode;
    /**
     * 业务基点结算价格
     */
    @DecimalMin(value = "0.01",message = "打款金额不可为空")
    @Digits(integer = 10, fraction = 2, message = "最多两位小数")
    private BigDecimal settlementPrice;

    /**
     * 结算价格说明
     */
    private String priceRemark;

}