package com.roco.settle.api.request.invoice;

import com.roco.settle.api.enums.invoice.*;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 发票分页查询
 * @author dongjuntong
 */
@Data
public class InvoicePageReq implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     *订单号
     */
    private String orderCode;

    /**
     * 入库申请单号
     */
    private String applyCode;

    /**
     * 发票性质
     */
    private String invoiceNature;


    /**
     * 业务基点编码
     */
    private String basePointCode;

    /**
     * 供应商编码
     */
    private String supplierCode;


    /**
     * 开票主体类型 业务主体:BIZ_SUBJECT 供应商:SUPPLIER
     */
    private String invoiceSubjectType;


    /**
     * 发票号码
     */
    private String invoiceCode;


    /**
     * 发票代码
     */
    private String invoiceNo;


    /**
     * 发票类型   增值税专用发票：DEDICATED ，增值税普通发票：NORMAL
     */
    private String invoiceType;


    /**
     * 业务主体编码
     */
    private String bizSubjectCode;


    /**
     * 申请状态   正常：NORMAL    已作废: INVALID
     */
    private InvoiceStatusEnum status;

    /**
     * 发票到账状态
     */
    @Max(1)
    @Min(0)
    private Integer arriveStatus;

    /**
     *申请状态 草稿：DRAFT 待确认: UNCONFIRMED 已入库: CONFIRMED
     */
    private InvoiceApplyStatusEnum applyStatus;


    /**
     * 打款工单或者支付工单编号
     */
    private String paymentOrderCode;
}
