package com.roco.settle.api.entity.agent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.base.LogTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/10/30 14:22</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SettleStandardPackageLog implements Serializable {
    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 标准套餐编码（settle_standard_package.code）
     */
    private String packageCode;

    /**
     * 日志类型
     */
    @Column(name = "log_type")
    private LogTypeEnum logType;

    /**
     * 日志消息
     */
   private String logMsg;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人姓名
     */
    private String createName;

    public SettleStandardPackageLog(String packageCode, LogTypeEnum logType, String logMsg) {
        this.packageCode = packageCode;
        this.logType = logType;
        this.logMsg = logMsg;
    }
}