package com.roco.settle.api.entity.enterprisetansfer;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 对公转账申请单(SettleEnterpriseTransferApply)实体类
 *
 * @author Andrew
 * @since 2020-02-24 09:40:40
 */
@Data
@Table(name = "settle_enterprise_transfer_apply")
public class SettleEnterpriseTransferApply implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 业务基点简称  
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     * 是否人保机构  
     */
    private Long isPicc;

    /**
     * 人保机构编码  
     */
    private String piccOrgCode;

    /**
     * 事项名称  
     */
    private String itemName;

    /**
     * 事项说明  
     */
    private String itemDesc;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商编码  
     */
    private String supplierCode;

    /**
     * 供应商营业执照名称  
     */
    private String supplierLicenseName;

    /**
     * 供应商账户名称  
     */
    private String supplierAccountName;


    /**
     * 供应商账户类型
     */
    private String supplierAccountType;

    /**
     * 供应商收款账号  
     */
    private String supplierAccountNo;

    /**
     * 供应商收款账户别名
     */
    private String supplierAccountAlias;

    /**
     * 供应商开户银行  
     */
    private String supplierBank;

    /**
     * 供应商开户支行  
     */
    private String supplierSubbranch;

    /**
     * 供应商银行账号  
     */
    private String supplierAccount;


    /**
     * 服务清单总套餐金额
     */
    private BigDecimal totalPackageAmount;

    /**
     * 服务清单结算总金额
     */
    private BigDecimal totalSettleAmount;

    /**
     * 服务清单数  
     */
    private Integer totalQuantity;

    /**
     * 申请附件地址  
     */
    private String applyFileUrl;

    /**
     * 申请附件名
     */
    private String applyFileName;

    /**
     * 主体结算工单
     */
    private String settleOrderNo;


    /**
     * 基点结算工单
     */
    private String basePointSettleOrderNo;

    /**
     * 状态  
     */
    private String status;

    /**
     * 供应商发票类型
     */
    private String invoiceType;

    /**
     * 供应商发票点数
     */
    private BigDecimal invoiceRate;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String updateUser;

    private String updateName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate updateDate;

   

}