package com.roco.settle.api.entity.policy;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 保单申请单日志(PolicyGiftDirectApplyLog)实体类
 *
 * @author luoyingchang
 * @since 2020-07-14 13:21:21
 */
@Data
@Table(name = "policy_gift_direct_apply_log")
public class PolicyGiftDirectApplyLog implements Serializable {


    @Id
    private Integer id;

    /**
     * 申请单号(唯一)
     */
    private String applyNo;

    /**
     * 操作: 提交:submit、作废: invalid、处理: handle、结算: settle
     */
    private String operation;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 操作日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;


}