package com.roco.settle.api.entity.productconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.productconfig.GiftTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/20 13:17</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Table(name="settle_enterprise_default_gift_type_config")
@Data
public class SettleEnterpriseDefaultGiftTypeConfig implements Serializable {

    @Id
    private Long id;

    /**
     * 企业编码
     */
    private String enterpriseCode;


    /**
     * 企业简称
     */
    private String enterpriseSimpleName;

    /**
     * 销售主体编码
     */
    private String subjectCode;

    /**
     * 销售主体编码
     */
    @Transient
    private String subjectSimpleName;

    /**
     * 机构默认礼品类型:COUPONS 电子券类型  PACKAGE 套餐
     */
    @Column(name="gift_type")
    private GiftTypeEnum giftType;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 修改人
     */
    private Long updateUser;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     *  更新人姓名
     */
    private String updateName;

}