package com.roco.settle.api.entity.productconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.productconfig.EnterpriseProductUpdateTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/06/17 15:43</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "settle_enterprise_product_update_history")
public class SettleEnterpriseProductUpdateHistory implements Serializable {
    @Id
    private Integer id;

    /**
     * 机构商品配置编码
     */
    private String configCode;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 机构编号
     */
    private String enterpriseCode;

    /**
     * 是否为默认产品
     */
    private String isDefault;

    /**
     * 销售价
     */
    private BigDecimal sellPrice;

    /**
     * 更新类型
     */
    @Column(name="update_type")
    private String updateType;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;


    /**
     * 默认通道产品编号
     */
    private String channelProductCode;

    /**
     * 默认通道产品名称
     */
    private String channelProductName;

}