package com.roco.settle.api.entity.productconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/2 18:54</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Table(name="settle_product_package")
@Data
public class SettleProductPackage implements Serializable {
    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 编号
     */
    private String code;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseSimpleName;

    /**
     * 销售主体编号
     */
    private String subjectCode;

    /**
     * 销售主体简称
     */
    private String subjectSimpleName;

    /**
     * 套餐编码
     */
    private String productPackageCode;

    /**
     * 套餐名称
     */
    private String productPackageName;


    /**
     * 套餐名称拼音
     */
    @Column(name="package_name_pinyin")
    private String packageNamePinyin;

    /**
     * 套餐总面值
     */
    private Integer faceValue;


    /**
     * 套餐总销售价
     */
    private BigDecimal sellingPrice;

    /**
     * 套餐产品数
     */
    private Integer productCnt;


    /**
     * 套餐说明
     */
    private String remark;

    /**
     * 套餐状态
     */
    private Integer status;

    /**
     * 默认套餐
     */
    private Integer isDefault;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     *  
     */
    private String createName;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     *  
     */
    private String updateName;

}