package com.roco.settle.api.entity.productconfig;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/2 18:54</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Table(name="settle_product_package_item")
@Data
public class SettleProductPackageItem implements Serializable {
    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 套餐产品编码
     */
    private String packageCode;

    /**
     * 销售主体编码
     */
    private String subjectCode;


    /**
     * 销售主体可售产品编码
     */
    private String subjectProductCode;

    /**
     * 可售产品编码
     */
    private String productCode;

    /**
     * 可售产品简称
     */
    private String productSimpleName;

    /**
     * 类目编码
     */
    private String catalogCode;

    /**
     * 类目名称
     */
    private String productCatalogName;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 面值
     */
    private Integer facePrice;

    /**
     * 销售单价
     */
    private BigDecimal sellingPrice;

    /**
     * 电子券张数
     */
    private Integer count;



    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     *  
     */
    private String createName;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     *  
     */
    private String updateName;


}