package com.roco.settle.api.entity.remittance;

import java.time.LocalDateTime;

import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceFileTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务基点打款工单附件(SettleEnterpriseRemittanceFile)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:38:12
 */
@Data
@Table(name = "settle_enterprise_remittance_file")
public class SettleEnterpriseRemittanceFile implements Serializable {

   
    @Id
    private Long id;

    /**
     * 打款工单  
     */
    private String remittanceCode;

    /**
     * 批次号  
     */
    private String batchCode;

    /**
     * 组序号  
     */
    private Integer ordernum;

    /**
     * 资源类型(事项：MATTER)  
     */
    @Column(name="type")
    private SettleEnterpriseRemittanceFileTypeEnum type;

    /**
     * 文件类型(PDF,PNG,JPG,JPEG)  
     */
    private String fileType;

    /**
     * 路径url  
     */
    private String fileUrl;

    /**
     * 附件名称  
     */
    private String fileName;

    /**
     * 附件说明  
     */
    private String remark;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private Long createUser;

    /**
     *    
     */
    private String createName;

    /**
     *    
     */
    private String createUsertype;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人  
     */
    private Long updateUser;

    /**
     *    
     */
    private String updateName;

    /**
     *    
     */
    private String updateUsertype;

    /**
     * 逻辑删除（0：未删除，1：已删除）  
     */
    private Integer deleted;

   

}