package com.roco.settle.api.entity.subject;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Table(name = "settle_subject_supplier_contacts")
public class SettleSubjectSupplierContacts implements Serializable {

	/**
	 * 供应商联系人ID
	 */
	@Id
	private Long id;
	/**
	 * 姓名
	 */
	private String fullName;
	/**
	 * 联系电话
	 */
	private String phone;
	/**
	 * 固定电话
	 */
	private String tel;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 供应商编码(settle_subject_supplier.code)
	 */
	private String supplierCode;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;
    /**
     * 更新日期
     * */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

}
