package com.roco.settle.api.entity.supplier;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 供应商服务清单(SupplierServiceApply)实体类
 *
 * @author hsf
 * @since 2020-05-25 18:35:11
 */
@Data
@Table(name = "supplier_service_apply")
public class SupplierServiceApply implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单编码  
     */
    private String applyNo;

    /**
     * 供应商编码  
     */
    private String supplierCode;

    /**
     * 供应商名称  
     */
    private String supplierSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 总笔数  
     */
    private Integer totalCnt;

    /**
     * 总金额  
     */
    private BigDecimal totalAmount;

    /**
     * 提供附件日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate provideDate;

    /**
     * 附件名称  
     */
    private String attachName;

    /**
     * 申请单备注  
     */
    private String remark;

    /**
     * 附件url  
     */
    private String attachUrl;

    /**
     * 申请单状态  
     */
    private String status;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 提交时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime submitTime;

    /**
     * 提交日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate submitDate;

    /**
     * 取消时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime cancelTime;

    /**
     * 取消日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate cancelDate;

    /**
     * 处理完毕时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime finishTime;

    /**
     * 处理完毕日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate finishDate;

    /**
     * 创建人  
     */
    private Long createUser;

    /**
     * 创建人名称  
     */
    private String createName;

    /**
     * 更新人  
     */
    private Long updateUser;

    /**
     * 更新人名称  
     */
    private String updateName;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

   

}