package com.roco.settle.api.enums;

public enum ReceiptAccountTypeEnum {
    /**
     * 停用
     */
    PUBLIC("对公账户"),

    /**
     * 启用
     */
    PRIVATE("对私账户");

    private String name;

    ReceiptAccountTypeEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        ReceiptAccountTypeEnum[] values = ReceiptAccountTypeEnum.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
