package com.roco.settle.api.enums.billing;

/**
 * @author lanqian
 */

public enum SettleSubjectBillingStatusEnum {
    /**
     * 待开票
     * */
    WAIT_INVOICE("待开票"),
    /**
     * 已开票
     * */
    INVOICED("已开票"),
    /**
     * 已寄送
     * */
    SENT("已寄送发票"),
    /**
     * 客户已收到发票
     * */
    SINGED("客户已收到发票"),
    /**
     * 已取消
     * */
    CANCELLED("已取消");
    private String name;

    SettleSubjectBillingStatusEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        SettleSubjectBillingStatusEnum[] values = SettleSubjectBillingStatusEnum.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
