package com.roco.settle.api.enums.policygiftdirect;

import lombok.Getter;

/**
 * @author Andrew
 * @create 2020/7/16 2:45 下午
 */
public enum  PolicyGiftDirectBizStatus {

    draft("draft", "草稿"),
    invalid("invalid", "作废"),
    pending("pending", "待处理"),
    processed("processed","已处理");
    @Getter
    private String code;


    @Getter
    private String label;



    PolicyGiftDirectBizStatus( String code, String label) {
        this.code = code;
        this.label = label;
    }

    public static final String getLabelByCode(String code){
        for (PolicyGiftDirectBizStatus status : values()) {
            if (code != null && status.code.equals(code)) {
                return status.label;
            }
        }
        return code;
    }


}
