package com.roco.settle.api.enums.policygiftdirect;

import lombok.Getter;

/**
 * @author Andrew
 * @create 2020/7/16 2:45 下午
 */
public enum PolicyGiftDirectSettleStatus {
    unsettled("unsettled", "未结算"),
    settled("settled", "已结算");

    @Getter
    private String code;


    @Getter
    private String label;


    PolicyGiftDirectSettleStatus( String code, String label) {
        this.code = code;
        this.label = label;
    }

    public static final String getLabelByCode(String code){
        for (PolicyGiftDirectSettleStatus status : values()) {
            if (code != null && status.code.equals(code)) {
                return status.label;
            }
        }
        return code;
    }


}
