package com.roco.settle.api.enums.policygiftdirect;

import lombok.Getter;

public enum PolicyGiftDirectStatus {
    draft("draft", "草稿"),
    invalid("invalid", "作废"),
    pending("pending", "待处理"),
    settling("settling", "待结算"),
    finish("finish", "完成"),
    ;


    @Getter
    private String label;

    @Getter
    private String code;

    PolicyGiftDirectStatus(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public static String getByCode(String code) {
        for (PolicyGiftDirectStatus v : values()) {
            if (v.code.equals(code)) {
                return v.getLabel();
            }
        }

        return null;
    }

}
