package com.roco.settle.api.enums.policygiftdirect;

import lombok.Getter;

/**
 * @author Andrew
 * @create 2020/7/16 3:51 下午
 */
public enum PolicyGiftDirectType {

    premium("premium", "按保单保费"),

    net_premium("net_premium", "按保单净保费");


    @Getter
    private String code;

    @Getter
    private String label;

    PolicyGiftDirectType(String code, String label) {
        this.code = code;
        this.label = label;
    }


    public static final String getLabelByCode(String code) {
        for (PolicyGiftDirectType status : values()) {
            if (code != null && status.code.equals(code)) {
                return status.label;
            }
        }
        return code;
    }
}
