package com.roco.settle.api.enums.remittance;

public enum SettleEnterpriseRemittanceCapitalTypeEnum {
    /**
     * 预付款
     */
    ADVANCE_PAYMENT("预付款"),
    /**
     * 结算款
     * */
    SETTLEMENT_PAYMENT("结算款"),
    /**
     * 其他
     * */
    OTHER_PAYMENT("其他");

    private String name;

    SettleEnterpriseRemittanceCapitalTypeEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        SettleEnterpriseRemittanceCapitalTypeEnum[] values = SettleEnterpriseRemittanceCapitalTypeEnum.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
