package com.roco.settle.api.request.agent;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author djt
 * @Description: 标准套餐查询请求实体
 * @date 2020/10/30 13:29
 */
@Data
@Builder
public class StandardPackageProductSearchReq implements Serializable {

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 关键字筛选
     */
    private String keyword;

    /**
     * 套餐编码
     */
    private List<String> codes;

    /**
     *  成本价 最小
     */
    private BigDecimal minCostPrice;
    /**
     * 成本价 最大
     */
    private BigDecimal maxCostPrice;

    /**
     * 市场价 最小
     */
    private BigDecimal minMarketPrice;

    /**
     * 市场价 最大
     */
    private BigDecimal maxMarketPrice;

    /**
     * 预算
     */
    private BigDecimal budget;

    /**
     * 市场排序 asc
     */
    private String marketPriceSort;

    /**
     * 成本价排序 desc
     */
    private String costPriceSort;



}
