package com.roco.settle.api.request.billing;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.billing.SettleSubjectBillingSendTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lanqian
 */
@Data
public class SettleSubjectBillingSendSaveReq implements Serializable {

    /**
     * 寄送信息编码
     */
    private String code;

    /**
     * 开票工单号
     */
    @NotBlank
    private String billingCode;

    /**
     * 寄送类型
     */
    @NotNull
    private SettleSubjectBillingSendTypeEnum type;

    /**
     * 快递公司
     */
    private String expressCompany;

    /**
     * 快递单号
     */
    private String expressNumber;

    /**
     * 寄送时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime sendTime;

    /**
     * 签收时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime receiveTime;

    /**
     * 寄送负责人
     */
    private String courier;

    /**
     * 快递单截图
     */
    private String expressImage;

    /**
     * 签收凭证
     */
    private String receiveImage;

    /**
     * 备注
     */
    private String remark;

    /**添加的发票*/
    @NotNull(message ="请选择发票！")
    private List<Long> billingReferenceInvoiceIds;
}
