package com.roco.settle.api.request.enterprisesettle;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.io.Serializable;

/**
 * 业务基点-油卡结算 申请单 查询请求参数
 *
 * @author zhangmin
 * @create 2020/2/25 1:52 下午
 */
@Setter
@Getter
public class EnterpriseOilCardApplyQueryReq implements Serializable {


    private Integer settleYear;


    @Min(1)
    @Max(12)
    private Integer settleMonth;

    /**
     * 业务基点编号
     */
    private String enterpriseCode;

    /**
     * 业务主体编号
     */
    private String bizSubjectCode;


    /**
     * 事项名 关键词
     */
    private String itemName;

    /**
     * 申请单号
     */
    private String applyNo;


    private String status;


    private Boolean displayDelete;
}
