package com.roco.settle.api.request.productconfig;

import com.roco.settle.api.enums.productconfig.GiftTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author djt
 * @date 2020/7/20 14:13
 */
@Data
public class SettleEnterpriseDefaultGiftTypeConfigEditReq implements Serializable {
    /**
     * 企业编码
     */
    @NotBlank
    private String enterpriseCode;

    /**
     * 企业简称
     */
    @NotBlank
    private String enterpriseSimpleName;

    /**
     * 销售主体编码
     */
    @NotBlank
    private String subjectCode;

    /**
     * 机构默认礼品类型:COUPONS 电子券类型  PACKAGE 套餐
     */
    @NotNull
    private GiftTypeEnum giftType;

}
