package com.roco.settle.api.request.productconfig;

import com.roco.settle.api.enums.StatusEnum;
import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class SettleEnterpriseProductRelEditReq implements Serializable {
    @NotBlank
    private String model;
    @NotBlank
    private String enterpriseCode;
    @NotBlank
    private String enterpriseName;

    private String piccOrgCode;

    private String productCode;

    private BigDecimal sellPrice;

    private String productName;

    private String code;
    /**
     * 是否默认配置
     */
    @Pattern(regexp = ("^(Y|N)$"),message = "是否默认配置参数不匹配")
    @NotBlank(message = "是否默认配置不可以为空！")
    private String isDefault;


    /**
     * 默认通道产品编号
     */
    private String channelProductCode;

    /**
     * 默认通道产品名称
     */
    private String channelProductName;


    /**
     * 销售主体编码
     */
    private String subjectCode;


    /**
     * 销售主体简称
     */
    private String subjectSimpleName;


    /**
     * 销售主体可售产品编号
     */
    private String subjectProductCode;

    /**
     * 产品上下架
     */
    private StatusEnum available;



    private String remark;

    private List<String> subjectProductCodes;

    /**
     *市场价（20201208 价格只针对B端代理人）
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull(message = "市场价不能为空")
    private BigDecimal marketPrice;

}
