package com.roco.settle.api.request.remittance;

import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceFileTypeEnum;
import lombok.Data;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;

@Data
public class SettleEnterpriseRemittanceFileSaveReq implements Serializable {
    private Long id;
    /**
     * 打款工单
     */
    private String remittanceCode;
    /**
     * 批次号
     */
    private String batchCode;

    /**
     * 组序号
     */
    private Integer ordernum;

    /**
     * 资源类型(事项：MATTER)
     */
    private SettleEnterpriseRemittanceFileTypeEnum type;

    /**
     * 文件类型(PDF,PNG,JPG,JPEG)
     */
    private String fileType;

    /**
     * 路径url
     */
    private String fileUrl;

    /**
     * 附件名称
     */
    private String fileName;

    /**
     * 附件说明
     */
    private String remark;
    /**
     * 逻辑删除（0：未删除，1：已删除）
     */
    private Integer deleted;

    /**
     * 文件资源
     * */
    private  MultipartFile file;
}
