package com.roco.settle.api.response.productconfig;

import com.roco.settle.api.entity.productconfig.SettleEnterpriseProduct;
import com.roco.settle.api.entity.productconfig.SettleProductPackage;
import com.roco.settle.api.enums.productconfig.GiftTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author djt
 * @date 2020/7/22 13:14
 */
@Data
public class SettleEnterpriseProductInfoResp  implements Serializable {

    /**
     * 企业编号
     */
    private String enterpriseCode;


    /**
     * 默认的产品类型
     */
    private GiftTypeEnum defaultGiftType;

    /**
     * 套餐产品对应的默认产品编号
     */
    private String defaultPackageProductCode;

    /**
     * 电子券产品对应的默认产品编号
     */
    private String defaultCouponsProductCode;


    /**
     * 企业可选产品类型
     */
    private List<SettleEnterpriseGiftTypeResp> giftTypeOption;

    /**
     * 电子券产品列表
      */
    private List<SettleEnterpriseProduct>  enterpriseProductList;

    /**
     * 套餐产品列表
     */
    private List<SettleProductPackage>  packageProductList;
}
