package com.roco.settle.api.response.subject;

import com.roco.settle.api.entity.subject.SettleSubjectSupplier;
import com.roco.settle.api.enums.SupplierStatus;
import com.roco.settle.api.request.subject.SettleSubjectSupplierContactsReq;

import java.io.Serializable;
import java.util.List;

public class SettleSubjectSupplierRes extends SettleSubjectSupplier implements Serializable {

    /**
     * 联系人列表
     */
    private List<SettleSubjectSupplierContactsReq> contacts;

    private String subjectName;

    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 简介
     */
    private String description;
    /**
     * 地区编号
     */
    private String regionNo;
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    /**
     * 区
     */
    private String area;

    /**
     * 省
     */
    private String provinceCode;
    /**
     * 市
     */
    private String cityCode;
    /**
     * 区
     */
    private String areaCode;
    /**
     * 详细地址
     */
    private String address;
    /**
     * 法人
     */
    private String legalPerson;
    /**
     * 营业执照编号
     */
    private String businessLicenseNo;
    /**
     * 营业执照图片(阿里云)
     */
    private String businessLicenseImg;
    /**
     * 状态
     */
    private Integer status;

    /**
     * 搜索名
     */
    private String searchName;

    /**
     * 供应商类型
     * */
    private String providerType;

    /**
     * 服务类型
     * */
    private String categoryCode;

    /**
     * 服务类型
     * */
    private String categoryName;
    /**
     * *
     * * 是否主体*/
    private String mainPartType;

    /**
     * 主体编码
     * */
    private String mainPartCode;


    /**
     * 营业执照名称
     * */
    private String licenseName;
    /**
     * 营业执照名称
     * */
    private String licenseNamePy;

    /**
     * *
     * * 人保车务平台门店编号*/
    private String shopCode ;

    /**
     * 是否人保车务平台上架
     * */
    private String isOnline;
    /**
     * 商户类型
     * */
    private String merchantTypeCode;
    /**
     * 商户类型名称
     * */
    private String merchantTypeName;

    /**
     * 人保推修码
     */
    private String insuranceRepairNo;

    private String subjectSupplierNo;

    /**
     * 供应商性质
     * subject-集成服务商, platform-平台供应商
     */
    private String supplierNature;

    /**
     * 供应商的集成商编码
     * settle_biz_subject.supplier_no关联的subject_code
     */
    private String supplierSubjectCode;

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getStatusName(){
        return SupplierStatus.getName(getStatus());
    }

    public List<SettleSubjectSupplierContactsReq> getContacts() {
        return contacts;
    }

    public void setContacts(List<SettleSubjectSupplierContactsReq> contacts) {
        this.contacts = contacts;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRegionNo() {
        return regionNo;
    }

    public void setRegionNo(String regionNo) {
        this.regionNo = regionNo;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(String legalPerson) {
        this.legalPerson = legalPerson;
    }

    public String getBusinessLicenseNo() {
        return businessLicenseNo;
    }

    public void setBusinessLicenseNo(String businessLicenseNo) {
        this.businessLicenseNo = businessLicenseNo;
    }

    public String getBusinessLicenseImg() {
        return businessLicenseImg;
    }

    public void setBusinessLicenseImg(String businessLicenseImg) {
        this.businessLicenseImg = businessLicenseImg;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getProviderType() {
        return providerType;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getMainPartType() {
        return mainPartType;
    }

    public void setMainPartType(String mainPartType) {
        this.mainPartType = mainPartType;
    }

    public String getMainPartCode() {
        return mainPartCode;
    }

    public void setMainPartCode(String mainPartCode) {
        this.mainPartCode = mainPartCode;
    }

    public String getLicenseName() {
        return licenseName;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseNamePy() {
        return licenseNamePy;
    }

    public void setLicenseNamePy(String licenseNamePy) {
        this.licenseNamePy = licenseNamePy;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(String isOnline) {
        this.isOnline = isOnline;
    }

    public String getMerchantTypeCode() {
        return merchantTypeCode;
    }

    public void setMerchantTypeCode(String merchantTypeCode) {
        this.merchantTypeCode = merchantTypeCode;
    }

    public String getMerchantTypeName() {
        return merchantTypeName;
    }

    public void setMerchantTypeName(String merchantTypeName) {
        this.merchantTypeName = merchantTypeName;
    }

    public String getInsuranceRepairNo() {
        return insuranceRepairNo;
    }

    public void setInsuranceRepairNo(String insuranceRepairNo) {
        this.insuranceRepairNo = insuranceRepairNo;
    }

    public String getSubjectSupplierNo() {
        return subjectSupplierNo;
    }

    public void setSubjectSupplierNo(String subjectSupplierNo) {
        this.subjectSupplierNo = subjectSupplierNo;
    }

    public String getSupplierNature() {
        return supplierNature;
    }

    public void setSupplierNature(String supplierNature) {
        this.supplierNature = supplierNature;
    }

    public String getSupplierSubjectCode() {
        return supplierSubjectCode;
    }

    public void setSupplierSubjectCode(String supplierSubjectCode) {
        this.supplierSubjectCode = supplierSubjectCode;
    }
}
