package com.roco.settle.api.service;

import com.roco.settle.api.entity.SettleEnterpriseServiceApplyItem;
import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseTransferApply;
import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseTransferApplyLog;
import com.roco.settle.api.entity.supplier.SupplierServiceApplyItem;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.enterprisetansfer.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.enterprisetansfer.EnterpriseTransferFileRes;

/**
 * @author Andrew
 * @create 2020/2/24 1:39 下午
 */
public interface EnterpriseTransferService {


    /**
     * 对公转账清单上传
     *
     * 业务基点服务清单(settle_enterprise_service_apply_item)
     *
     * @param request
     * @return
     */
    @Deprecated
    CommonResponse<EnterpriseTransferFileRes> uploadFile(CommonRequest<EnterpriseTransferApplyFileReq> request);

    /**
     * 对公转账清单上传
     *
     * 服务商服务清单(supplier_service_apply_item)
     *
     * @param request
     * @return
     */
    CommonResponse<EnterpriseTransferFileRes> uploadFile2(CommonRequest<EnterpriseTransferApplyFileReq2> request);

    /**
     * 对公转账申请
     *
     * @param request
     * @return
     */
    CommonResponse<String> apply(CommonRequest<EnterpriseTransferApplyReq> request);


    /**
     * 分页查询
     *
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseTransferApply> page(CommonQueryPageRequest<EnterpriseTransferQueryReq> request);


    /**
     * 操作申请单
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> operate(CommonRequest<EnterpriseTransferOperateReq> request);


    /**
     * 详情
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseTransferApply> detail(CommonRequest<EnterpriseTransferQueryReq> request);


    /**
     * 日志查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseTransferApplyLog> log(CommonQueryPageRequest<EnterpriseTransferQueryReq> request);


    /**
     * 查询清单
     * @param request
     * @return
     */
    CommonQueryPageResponse<SupplierServiceApplyItem> itemPage(CommonQueryPageRequest<EnterpriseTransferQueryReq> request);


    /**
     * 临时文件的分页查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseServiceApplyItem> tempFilePage(CommonQueryPageRequest<EnterpriseTransferQueryReq> request);

    /**
     * TODO 可删除，数据修复完
     *
     * 修复历史数据
     *
     * 机构服务清单->供应商服务清单
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> toFixEnterpriseServiceApply2SupplierServiceApply(CommonRequest<EnterpriseTransferQueryReq> request);


}
